### AavLEA1 Trehalose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('FL Proteins.xlsx', sheet = 'AavLEA1 Trehalose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('0.01',
                                           '0.1',
                                           '1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Trehalose: Protein)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('lightsteelblue1', 'lightsteelblue1', 'lightsteelblue1',  'lightsteelblue1', 'lightsteelblue1',
                             'steelblue4',   'steelblue4', 'steelblue4', 'steelblue4', 'steelblue4'))+
  #add significane values
  geom_signif(
    y_position = c(32,32, 32,32, 65),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25),
    annotation = c("NS", "NS", "NS",'NS',"***"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("0.01", "0.1","1", "10","100"),
                   labels=c("1:100", "1:10","1:1", "10:1", "100:1"))


### AavLEA1 Sucrose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('FL Proteins.xlsx', sheet = 'AavLEA1 Sucrose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('0.01',
                                           '0.1',
                                           '1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Sucrose: Protein)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('honeydew', 'honeydew', 'honeydew',  'honeydew', 'honeydew',
                             'aquamarine4',   'aquamarine4', 'aquamarine4', 'aquamarine4', 'aquamarine4'))+
  #add significane values
  geom_signif(
    y_position = c(32, 32, 32,40, 50),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25),
    annotation = c("NS", "NS", "NS",'NS',"**"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("0.01", "0.1","1", "10","100"),
                   labels=c("1:100", "1:10","1:1", "10:1", "100:1"))




### AtLEA3-3 Trehalose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('FL Proteins.xlsx', sheet = 'AtLEA3-3 Trehalose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('0.01',
                                           '0.1',
                                           '1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Trehalose: Protein)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('lightsteelblue1', 'lightsteelblue1', 'lightsteelblue1',  'lightsteelblue1', 'lightsteelblue1',
                             'steelblue4',   'steelblue4', 'steelblue4', 'steelblue4', 'steelblue4'))+
  #add significane values
  geom_signif(
    y_position = c(50, 50, 50,50, 63),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25),
    annotation = c("NS", "NS", "NS",'NS',"**"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("0.01", "0.1","1", "10","100"),
                   labels=c("1:100", "1:10","1:1", "10:1", "100:1"))


### AtLEA3-3 Sucrose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('FL Proteins.xlsx', sheet = 'AtLEA3-3 Sucrose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('0.01',
                                           '0.1',
                                           '1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Sucrose: Protein)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('honeydew', 'honeydew', 'honeydew',  'honeydew', 'honeydew',
                             'aquamarine4',   'aquamarine4', 'aquamarine4', 'aquamarine4', 'aquamarine4'))+
  #add significane values
  geom_signif(
    y_position = c(40, 40, 40,50, 63),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25),
    annotation = c("NS", "NS", "NS",'*',"***"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("0.01", "0.1","1", "10","100"),
                   labels=c("1:100", "1:10","1:1", "10:1", "100:1"))


### AtLEA4-2 Trehalose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('FL Proteins.xlsx', sheet = 'AtLEA4-2 Trehalose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('0.01',
                                           '0.1',
                                           '1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Trehalose: Protein)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('lightsteelblue1', 'lightsteelblue1', 'lightsteelblue1',  'lightsteelblue1', 'lightsteelblue1',
                             'steelblue4',   'steelblue4', 'steelblue4', 'steelblue4', 'steelblue4'))+
  #add significane values
  geom_signif(
    y_position = c(26, 26, 26,30, 57),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25),
    annotation = c("NS", "NS", "NS",'NS',"NS"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("0.01", "0.1","1", "10","100"),
                   labels=c("1:100", "1:10","1:1", "10:1", "100:1"))
### AtLEA4-2 Sucrose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('FL Proteins.xlsx', sheet = 'AtLEA4-2 Sucrose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('0.01',
                                           '0.1',
                                           '1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Sucrose: Protein)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('honeydew', 'honeydew', 'honeydew',  'honeydew', 'honeydew',
                             'aquamarine4',   'aquamarine4', 'aquamarine4', 'aquamarine4', 'aquamarine4'))+
  #add significane values
  geom_signif(
    y_position = c(26, 26, 26,38, 72),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25),
    annotation = c("*", "NS", "NS",'**',"**"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("0.01", "0.1","1", "10","100"),
                   labels=c("1:100", "1:10","1:1", "10:1", "100:1"))



### AvLEA1C Trehalose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('FL Proteins.xlsx', sheet = 'AvLEA1C Trehalose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('0.01',
                                           '0.1',
                                           '1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Trehalose: Protein)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('lightsteelblue1', 'lightsteelblue1', 'lightsteelblue1',  'lightsteelblue1', 'lightsteelblue1',
                             'steelblue4',   'steelblue4', 'steelblue4', 'steelblue4', 'steelblue4'))+
  #add significane values
  geom_signif(
    y_position = c(62, 69, 62,64, 64),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25),
    annotation = c("NS", "NS", "NS",'NS',"NS"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("0.01", "0.1","1", "10","100"),
                   labels=c("1:100", "1:10","1:1", "10:1", "100:1"))


### AvLEA1C Sucrose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('FL Proteins.xlsx', sheet = 'AvLEA1C Sucrose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('0.01',
                                           '0.1',
                                           '1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Sucrose: Protein)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('honeydew', 'honeydew', 'honeydew',  'honeydew', 'honeydew',
                             'aquamarine4',   'aquamarine4', 'aquamarine4', 'aquamarine4', 'aquamarine4'))+
  #add significane values
  geom_signif(
    y_position = c(60, 60, 60,62, 64),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25),
    annotation = c("NS", "NS", "NS",'NS',"NS"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("0.01", "0.1","1", "10","100"),
                   labels=c("1:100", "1:10","1:1", "10:1", "100:1"))



### CAHS D Trehalose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('FL Proteins.xlsx', sheet = 'CAHS D Trehalose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Trehalose: Protein)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('lightsteelblue1', 'lightsteelblue1', 'lightsteelblue1',
                             'steelblue4',   'steelblue4', 'steelblue4'))+
  #add significane values
  geom_signif(
    y_position = c(50, 60, 90),
    xmin = c(.75, 1.75, 2.75),
    xmax = c(1.25, 2.25, 3.25),
    annotation = c("NS", "*", "***"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("1", "10","100"),
                   labels=c("1:1", "10:1", "100:1"))

### CAHS D Sucrose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('FL Proteins.xlsx', sheet = 'CAHS D Sucrose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Sucrose: Protein)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('honeydew', 'honeydew', 'honeydew',
                             'aquamarine4',   'aquamarine4', 'aquamarine4'))+
  #add significane values
  geom_signif(
    y_position = c(50, 50, 80),
    xmin = c(.75, 1.75, 2.75),
    xmax = c(1.25, 2.25, 3.25),
    annotation = c("NS", "NS", "***"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("1", "10","100"),
                   labels=c("1:1", "10:1", "100:1"))




### HeLEA68614 Trehalose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('FL Proteins.xlsx', sheet = 'HeLEA Trehalose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('0.01',
                                           '0.1',
                                           '1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Trehalose: Protein)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('lightsteelblue1', 'lightsteelblue1', 'lightsteelblue1',  'lightsteelblue1', 'lightsteelblue1',
                             'steelblue4',   'steelblue4', 'steelblue4', 'steelblue4', 'steelblue4'))+
  #add significane values
  geom_signif(
    y_position = c(60, 60, 60,62, 64),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25),
    annotation = c("NS", "NS", "NS",'*',"***"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("0.01", "0.1","1", "10","100"),
                   labels=c("1:100", "1:10","1:1", "10:1", "100:1"))


### HeLEA68614 Sucrose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('FL Proteins.xlsx', sheet = 'HeLEA Sucrose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('0.01',
                                           '0.1',
                                           '1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Sucrose: Protein)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('honeydew', 'honeydew', 'honeydew',  'honeydew', 'honeydew',
                             'aquamarine4',   'aquamarine4', 'aquamarine4', 'aquamarine4', 'aquamarine4'))+
  #add significane values
  geom_signif(
    y_position = c(44, 44, 44,47, 52),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25),
    annotation = c("NS", "NS", "NS",'NS',"NS"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("0.01", "0.1","1", "10","100"),
                   labels=c("1:100", "1:10","1:1", "10:1", "100:1"))




### BSA Trehalose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('FL Proteins.xlsx', sheet = 'BSA Trehalose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('0.01',
                                           '0.1',
                                           '1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Trehalose: Protein)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('lightsteelblue1', 'lightsteelblue1', 'lightsteelblue1',  'lightsteelblue1', 'lightsteelblue1',
                             'steelblue4',   'steelblue4', 'steelblue4', 'steelblue4', 'steelblue4'))+
  #add significane values
  geom_signif(
    y_position = c(42, 42, 42,42, 61),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25),
    annotation = c("NS", "NS", "NS",'NS',"NS"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("0.01", "0.1","1", "10","100"),
                   labels=c("1:100", "1:10","1:1", "10:1", "100:1"))


### BSA Sucrose

#Set working directory----
setwd('~/Desktop/')

#Import necessary packages----
library(ggplot2)
library(dplyr)
library(readxl)
library(ggsignif)

#Import your dataset----
data <- read_xlsx('FL Proteins.xlsx', sheet = 'BSA Sucrose')
#Change the factor order
data$Ratio <- factor(data$Ratio,levels = c('0.01',
                                           '0.1',
                                           '1',
                                           '10',
                                           '100'))

#####make plot----
#create ggplot Environment----
ggplot(data = data, aes(x = Ratio, y = Protect_add, fill = interaction(Ratio, Calculation)))+
  #Make stacked bar graph---- 
##Make bottom layer first 
geom_col(data = data %>% filter(Protectant == 'Sugar'| Protectant == 'Mixed'), 
         position = position_dodge(width = .9), 
         color = 'black')+
  ##Make top layer w/ alpha adjustment
  geom_col(data = data %>% filter(Protectant == 'Protein'| Protectant == 'Mixed'), 
           position = position_dodge(width = .9), 
           alpha = .6, 
           color = 'black')+
  #Set y-axis scale
  scale_y_continuous(name = 'LDH Protection (%)',
                     breaks = seq(0,100,20),
                     limits = c(0,100))+  
  #Set graph labels
  labs(x = 'Molar Ratio (Sucrose: Protein)',
       y = '%Protection',
       title = '')+
  #Make Black and white theme
  theme_bw()+
  #Adjust graph settings
  theme(
    plot.title = element_text(hjust = 0.05, size = 12, vjust = -8),
    axis.title = element_text(size =12),
    axis.text = element_text(size =10),
    legend.text=element_text(size=14), 
    legend.position = 'none', aspect.ratio = .5,
    panel.border = element_rect(colour = "black", fill=NA, size=1))+
  #add error bars based on standard deviation
  geom_errorbar(aes(ymin = Protect_add - Stdev, ymax = Protect_add + Stdev), width = .2, position = position_dodge(.9))+
  #custom assignment of bar color----
scale_fill_manual(values = c('honeydew', 'honeydew', 'honeydew',  'honeydew', 'honeydew',
                             'aquamarine4',   'aquamarine4', 'aquamarine4', 'aquamarine4', 'aquamarine4'))+
  #add significane values
  geom_signif(
    y_position = c(42, 42, 42,42, 57),
    xmin = c(.75, 1.75, 2.75, 3.75,4.75),
    xmax = c(1.25, 2.25, 3.25, 4.25, 5.25),
    annotation = c("NS", "NS", "NS",'NS',"NS"),
    tip_length = 0, color = "black")+
  #rename x-labels
  scale_x_discrete(breaks=c("0.01", "0.1","1", "10","100"),
                   labels=c("1:100", "1:10","1:1", "10:1", "100:1"))


